### 通用操作

以下部分对控制工具箱中的功能块进行概要描述。

#### 功能块输入

##### E\_CtrlMode

大多数功能块的运行模式可通过该输入进行选择，从而支持以下运行模式：

| 名称                          | 类型  | 初始化 | 描述     |
| --------------------------- | --- | --- | ------ |
| eCTRL\_MODE\_IDLE           | INT | 0   | 空闲模式   |
| eCTRL\_MODE\_PASSIVE        | INT | 1   | 被动模式   |
| eCTRL\_MODE\_ACTIVE         | INT | 2   | 主动模式   |
| eCTRL\_MODE\_RESET          | INT | 3   | 复位模式   |
| eCTRL\_MODE\_MANUAL         | INT | 4   | 手动模式   |
| eCTRL\_MODE\_TUNE           | INT | 5   | 调试模式   |
| eCTRL\_MODE\_SELFTEST       | INT | 6   | 自检模式   |
| eCTRL\_MODE\_SYNC\_MOVEMENT | INT | 7   | 同步运动模式 |
| eCTRL\_MODE\_FREEZE         | INT | 8   | 冻结模式   |

##### stParams

必要的参数通过此结构传递到功能块。所有参数结构中都包含变量 **tTaskCycleTime** 和 **tCtrlCycleTime**，它们的作用如下：

参数 **tTaskCycleTime** 指定功能块的调用周期。如果功能块在每个周期调用，则该值等于调用任务的周期时间；如果每隔一个周期调用一次，则该值应相应加倍。

参数 **tCtrlCycleTime** 指定控制回路的采样时间，该值必须大于或等于 **tTaskCycleTime**。如果**tCtrlCycleTime** 等于 **tTaskCycleTime**，则功能块在每次调用时执行。如果 **tCtrlCycleTime** 设定为 **tTaskCycleTime** 的 5 倍，则功能块仅在每 5 次调用中执行一次。这样可以在快速任务中实现慢速控制回路。

参数 **tTaskCycleTime** 和 **tCtrlCycleTime** 的数据类型为 **TIME**，因此不允许输入小于 **1ms** 的值。

为了在周期时间小于 **1ms** 的高速 PLC 任务中使用控制器，可以指定一个全局基准时间作为周期时间的参考。基准时间的使用将在以下示例中说明。

假设功能块在每个任务周期中都被调用。

| Task： Configuration | tTaskCycleTime |  tCtrlCycleTime | Action                            |
| ------------------- | -------------- | --------------- | --------------------------------- |
| T#10ms              | T#10ms         | T#10ms          | 控制回路以 **10ms** 的采样时间进行处理          |
| T#10ms              | T#10ms         | T#50ms          | 控制回路以 **50ms** 的采样时间进行处理          |
| T#100ms             | T#100ms        | T#100ms         | 控制回路以 **100ms** 的采样时间进行处理         |
| T#100ms             | T#100ms        | T#50ms          | **错误**，无法执行！                      |
| T#100ms             | T#50ms         | T#50ms          | **错误，**&#x529F;能块已执行，但计算出的输出值不正确！ |

#### 功能块输出

##### E\_CtrlState

此输出指示功能块的当前内部状态

| 名称                          | 类型  | 初始化 | 描述     |
| --------------------------- | --- | --- | ------ |
| eCTRL\_MODE\_IDLE           | INT | 0   | 空闲状态   |
| eCTRL\_MODE\_PASSIVE        | INT | 1   | 被动状态   |
| eCTRL\_MODE\_ACTIVE         | INT | 2   | 主动状态   |
| eCTRL\_MODE\_RESET          | INT | 3   | 复位状态   |
| eCTRL\_MODE\_MANUAL         | INT | 4   | 手动状态   |
| eCTRL\_MODE\_TUNING         | INT | 5   | 正在调试   |
| eCTRL\_MODE\_TUNED          | INT | 6   | 调试完成   |
| eCTRL\_MODE\_SELFTEST       | INT | 7   | 自检状态   |
| eCTRL\_MODE\_ERROR          | INT | 8   | 错误状态   |
| eCTRL\_MODE\_SYNC\_MOVEMENT | INT | 9   | 同步运动状态 |
| eCTRL\_MODE\_FREEZE         | INT | 10  | 冻结状态   |

##### bError

该布尔输出的TRUE，指示功能块中出现错误。

##### eErrorId &#x20;

bError输出值为TRUE时，此处输出错误码。

---
### 功能块

### **（一）Controller**

#### **FB\_3Point**
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef51cee438.png)


控制器功能块 **FB\_3Point** 具有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称             | **类型**      | 描述 |
| -------------- | ----------- | -- |
| fSetpointValue | LREAL       |    |
| fActualValue   | LREAL       |    |
| nManSyncValue  | INT         |    |
| bSync          | BOOL        |    |
| eMode          | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**           | 描述 |
| -------- | ---------------- | -- |
| stParams | ST\_3PointParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| bPosOut    | BOOL             |    |
| bNegOut    | BOOL             |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_3PointParams**

| **名称**         | **类型** | 初始化      | 描述 |
| -------------- | ------ | -------- | -- |
| tCtrlCycleTime | TIME   | TIME#0ms |    |
| tTaskCycleTime | TIME   | TIME#0ms |    |
| fPosOutOn      | LREAL  |          |    |
| fPosOutOff     | LREAL  |          |    |
| fNegOutOn      | LREAL  |          |    |
| fNegOutOff     | LREAL  |          |    |

#### **FB\_3PointExt**
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef531ee34d.png)


控制器功能块 **FB\_3PointExt** 具有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称             | **类型**      | 描述 |
| -------------- | ----------- | -- |
| fSetpointValue | LREAL       |    |
| fActualValue   | LREAL       |    |
| fManSyncValue  | LREAL       |    |
| bSync          | BOOL        |    |
| eMode          | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**              | 描述 |
| -------- | ------------------- | -- |
| stParams | ST\_3PointExtParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_3PointExtParams**

| **名称**         | **类型** | 初始化      | 描述 |
| -------------- | ------ | -------- | -- |
| tCtrlCycleTime | TIME   | TIME#0ms |    |
| tTaskCycleTime | TIME   | TIME#0ms |    |
| fOutOff        | LREAL  |          |    |
| fOutOn         | LREAL  |          |    |
| fGain          | LREAL  |          |    |
| fOffset        | LREAL  |          |    |

#### **FB\_P**
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef53df40a8.png)


控制器功能块 **FB\_P** 具有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称    | **类型**      | 描述 |
| ----- | ----------- | -- |
| fIn   | LREAL       |    |
| eMode | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**      | 描述 |
| -------- | ----------- | -- |
| stParams | ST\_PParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_PParams**

| **名称**         | **类型** | 初始化      | 描述 |
| -------------- | ------ | -------- | -- |
| tCtrlCycleTime | TIME   | TIME#0ms |    |
| tTaskCycleTime | TIME   | TIME#0ms |    |
| fKp            | LREAL  |          |    |

#### **FB\_PI**
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef548f392c.png)


控制器功能块 **FB\_PI&#x20;**&#x5177;有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称             | **类型**      | 描述                    |
| -------------- | ----------- | --------------------- |
| fSetpointValue | LREAL       | 设定值                   |
| fActualValue   | LREAL       | 实际值                   |
| fManSyncValue  | LREAL       | 手动模式或同步模式下的输出值        |
| bSync          | BOOL        | 上升沿设置输出为nManSyncValue |
| eMode          | E\_CtrlMode | 控制模式                  |
| bHold          | BOOL        | 积分保持                  |

**VAR\_IN\_OUT**

| **名称**   | **类型**       | 描述 |
| -------- | ------------ | -- |
| stParams | ST\_PIParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述         |
| ---------- | ---------------- | ---------- |
| fOut       | LREAL            | 控制输出       |
| bARWactive | BOOL             | fOut 达到限制值 |
| eState     | E\_CtrlState     |            |
| eErrorId   | E\_CtrlErrorCode |            |
| bError     | BOOL             |            |

##### 结构体

**ST\_PIParams**

| **名称**          | **类型** | 初始化      | 描述 |
| --------------- | ------ | -------- | -- |
| tCtrlCycleTime  | TIME   | TIME#0ms |    |
| tTaskCycleTime  | TIME   | TIME#0ms |    |
| tTn             | TIME   |          |    |
| fKp             | REAL   |          |    |
| fOutMaxLimit    | LREAL  |          |    |
| fOutMinLimit    | LREAL  |          |    |
| bARWOnIPartOnly | BOOL   |          |    |

#### **FB\_PID**
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef5eee484e.png)


控制器功能块 **FB\_PID&#x20;**&#x5177;有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称             | **类型**      | 描述                    |
| -------------- | ----------- | --------------------- |
| fSetpointValue | LREAL       | 设定值                   |
| fActualValue   | LREAL       | 实际值                   |
| fManSyncValue  | LREAL       | 手动模式或同步模式下的输出值        |
| bSync          | BOOL        | 上升沿设置输出为nManSyncValue |
| eMode          | E\_CtrlMode | 控制模式                  |
| bHold          | BOOL        | 积分保持                  |

**VAR\_IN\_OUT**

| **名称**   | **类型**        | 描述 |
| -------- | ------------- | -- |
| stParams | ST\_PIDParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述         |
| ---------- | ---------------- | ---------- |
| fOut       | LREAL            | 控制输出       |
| bARWactive | BOOL             | fOut 达到限制值 |
| eState     | E\_CtrlState     |            |
| eErrorId   | E\_CtrlErrorCode |            |
| bError     | BOOL             |            |

##### 结构体

**ST\_PIDParams**

| **名称**              | **类型** | 初始化      | 描述 |
| ------------------- | ------ | -------- | -- |
| tCtrlCycleTime      | TIME   | TIME#0ms |    |
| tTaskCycleTime      | TIME   | TIME#0ms |    |
| fKp                 | LREAL  |          |    |
| tTn                 | TIME   |          |    |
| tTv                 | TIME   |          |    |
| tTd                 | TIME   |          |    |
| fOutMaxLimit        | LREAL  |          |    |
| fOutMinLimit        | LREAL  |          |    |
| bPInTheFeedbackPath | BOOL   |          |    |
| bDInTheFeedbackPath | BOOL   |          |    |
| bARWOnIPartOnly     | BOOL   |          |    |

#### **FB\_PIDSplitRange**
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef64682206.png)


控制器功能块 **FB\_PIDSplitRange** 具有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称               | **类型**                 | 描述                    |
| ---------------- | ---------------------- | --------------------- |
| fSetpointValue   | LREAL                  | 设定值                   |
| fActualValue     | LREAL                  | 实际值                   |
| eParameterRecord | E\_CtrlParameterRecord |                       |
| fManSyncValue    | LREAL                  | 手动模式或同步模式下的输出值        |
| bSync            | BOOL                   | 上升沿设置输出为nManSyncValue |
| eMode            | E\_CtrlMode            | 控制模式                  |
| bHold            | BOOL                   | 积分保持                  |

**VAR\_IN\_OUT**

| **名称**   | **类型**                  | 描述 |
| -------- | ----------------------- | -- |
| stParams | ST\_PIDSplitRangeParams |    |

**VAR\_OUTPUT**

| **名称**                 | **类型**           | 描述         |
| ---------------------- | ---------------- | ---------- |
| fOutPos                | LREAL            |            |
| fOutNeg                | LREAL            |            |
| fOut                   | LREAL            | 控制输出       |
| bARWactive             | BOOL             | fOut 达到限制值 |
| bParameterChangeActive | BOOL             |            |
| eState                 | E\_CtrlState     |            |
| eErrorId               | E\_CtrlErrorCode |            |
| bError                 | BOOL             |            |

##### 结构体

**ST\_PIDSplitRangeParams**

| **名称**                     | **类型** | 初始化      | 描述 |
| -------------------------- | ------ | -------- | -- |
| tCtrlCycleTime             | TIME   | TIME#0ms |    |
| tTaskCycleTime             | TIME   | TIME#0ms |    |
| fKp\_heating               | LREAL  | 0        |    |
| tTn\_heating               | TIME   | TIME#0ms |    |
| tTv\_heating               | TIME   | TIME#0ms |    |
| tTd\_heating               | TIME   | TIME#0ms |    |
| fKp\_cooling               | LREAL  | 0        |    |
| tTn\_cooling               | TIME   | TIME#0ms |    |
| tTv\_cooling               | TIME   | TIME#0ms |    |
| tTd\_cooling               | TIME   | TIME#0ms |    |
| nParameterChangeCycleTicks | UDINT  |          |    |
| fOutMaxLimit               | LREAL  | 1E+38    |    |
| fOutMinLimit               | LREAL  | -1E+38   |    |
| bPInTheFeedbackPath        | BOOL   | FALSE    |    |
| bDInTheFeedbackPath        | BOOL   | FALSE    |    |
| bARWOnIPartOnly            | BOOL   | FALSE    |    |

#### **FB\_PIDExtSplitRange**
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef65157ee7.png)


控制器功能块 **FB\_PIDExtSplitRange&#x20;**&#x5177;有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称               | **类型**                 | 描述                    |
| ---------------- | ---------------------- | --------------------- |
| fSetpointValue   | LREAL                  | 设定值                   |
| fActualValue     | LREAL                  | 实际值                   |
| eParameterRecord | E\_CtrlParameterRecord |                       |
| fManSyncValue    | LREAL                  | 手动模式或同步模式下的输出值        |
| bSync            | BOOL                   | 上升沿设置输出为nManSyncValue |
| eMode            | E\_CtrlMode            | 控制模式                  |
| bHold            | BOOL                   | 积分保持                  |

**VAR\_IN\_OUT**

| **名称**   | **类型**                     | 描述 |
| -------- | -------------------------- | -- |
| stParams | ST\_PIDExtSplitRangeParams |    |

**VAR\_OUTPUT**

| **名称**                 | **类型**           | 描述         |
| ---------------------- | ---------------- | ---------- |
| fOutPos                | LREAL            |            |
| fOutNeg                | LREAL            |            |
| fOut                   | LREAL            | 控制输出       |
| fOut\_WithoutDeadband  | LREAL            | 无死区限制控制值   |
| bARWactive             | BOOL             | fOut 达到限制值 |
| bParameterChangeActive | BOOL             |            |
| eState                 | E\_CtrlState     |            |
| eErrorId               | E\_CtrlErrorCode |            |
| bError                 | BOOL             |            |

##### 结构体

**ST\_PIDEXTSplitRangeParams**

| **名称**                     | **类型** | 初始化      | 描述 |
| -------------------------- | ------ | -------- | -- |
| tCtrlCycleTime             | TIME   | TIME#0ms |    |
| tTaskCycleTime             | TIME   | TIME#0ms |    |
| fKp\_heating               | LREAL  | 0        |    |
| tTn\_heating               | TIME   | TIME#0ms |    |
| tTv\_heating               | TIME   | TIME#0ms |    |
| tTd\_heating               | TIME   | TIME#0ms |    |
| fKp\_cooling               | LREAL  | 0        |    |
| tTn\_cooling               | TIME   | TIME#0ms |    |
| tTv\_cooling               | TIME   | TIME#0ms |    |
| tTd\_cooling               | TIME   | TIME#0ms |    |
| nParameterChangeCycleTicks | UDINT  |          |    |
| fDeadBandInput             | LREAL  | 0.0      |    |
| fDeadBandOutput            | LREAL  | 0.0      |    |
| fInnerWindow               | LREAL  | 0.0      |    |
| fOuterWindow               | LREAL  | 0.0      |    |
| fOutMaxLimit               | LREAL  | 1E+38    |    |
| fOutMinLimit               | LREAL  | -1E+38   |    |
| bPInTheFeedbackPath        | BOOL   | FALSE    |    |
| bDInTheFeedbackPath        | BOOL   | FALSE    |    |
| bARWOnIPartOnly            | BOOL   | FALSE    |    |

#### **FB\_PIDSplitRangeParameterSwitch**
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef65ec506d.png)


控制器功能块 **FB\_PIDSplitRangeParameterSwitch&#x20;**&#x5177;有多个输入和输出，具体描述如下。所有控制器的参数均通过结构体传递给功能块。

##### **接口**

**VAR\_INPUT**

| 名称                   | **类型**      | 描述                    |
| -------------------- | ----------- | --------------------- |
| fManipulatedVariable | LREAL       |                       |
| bDisableHeating      | BOOL        |                       |
| bDisableCooling      | BOOL        |                       |
| nManSyncValue        | INT         |                       |
| bSync                | BOOL        | 上升沿设置输出为nManSyncValue |
| eMode                | E\_CtrlMode | 控制模式                  |

**VAR\_IN\_OUT**

| **名称**   | **类型**                                 | 描述 |
| -------- | -------------------------------------- | -- |
| stParams | ST\_PIDSplitRangeParameterSwitchParams |    |

**VAR\_OUTPUT**

| **名称**           | **类型**                 | 描述 |
| ---------------- | ---------------------- | -- |
| eParameterRecord | E\_CtrlParameterRecord |    |
| fOutMaxLimit     | LREAL                  |    |
| fOutMinLimit     | LREAL                  |    |
| eState           | E\_CtrlState           |    |
| eErrorId         | E\_CtrlErrorCode       |    |
| bError           | BOOL                   |    |

##### 结构体

**ST\_PIDSplitRangeParameterSwitchParams**

| **名称**         | **类型** | 初始化      | 描述 |
| -------------- | ------ | -------- | -- |
| tCtrlCycleTime | TIME   | TIME#0ms |    |
| tTaskCycleTime | TIME   | TIME#0ms |    |
| fThreshold     | LREAL  |          |    |
| fOutMaxLimit   | LREAL  |          |    |
| fOutMinLimit   | LREAL  |          |    |
| bMinWaitTime   | TIME   |          |    |

### **（二）MC**

#### FB\_CoERead
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef669b3f9d.png)


##### **接口**

**VAR\_INPUT**

| 名称     | **类型** | 初始化   |
| ------ | ------ | ----- |
| Excute | BOOL   | FALSE |

**VAR\_IN\_OUT**

| **名称**   | **类型**            | 初始化 |
| -------- | ----------------- | --- |
| stParams | ST\_CoEReadParams |     |

**VAR\_OUTPUT**

| **名称**    | **类型**         | 初始化                               |
| --------- | -------------- | --------------------------------- |
| Done      | BOOL           | FALSE                             |
| Busy      | BOOL           | FALSE                             |
| Error     | BOOL           | FALSE                             |
| ErrorId   | ETC\_CO\_Error | ETC\_CO\_ERROR.ETC\_CO\_NO\_ERROR |

##### 结构体

**ST\_CoEReadParams**

| **名称**     | **类型**               | 初始化 | 描述 |
| ---------- | -------------------- | --- | -- |
| wIndex     | WORD                 | 0   |    |
| bySubindex | BYTE                 | 0   |    |
| pBuffer    | CAA.PVOID            | 0   |    |
| szSize     | CAA.SIZE             |     |    |
| pETCSlave  | POINTERV TO ETCSlave |     |    |

#### FB\_CoEReset
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef673ee64b.png)


##### **接口**

**VAR\_INPUT**

| 名称        | **类型** | 描述                                             |
| --------- | ------ | ---------------------------------------------- |
| Excute    | BOOL   | 上升沿触发                                          |
| ResetType | USINT  | bit0：复位轴报警 bit1：复位轴状态 bit2：复位驱动器状态 bit3：复位总线状态 |

**VAR\_IN\_OUT**

| **名称** | **类型**         | 描述    |
| ------ | -------------- | ----- |
| Axis   | AXIS\_REF\_SM3 | 轴名称   |
| Drive  | ETCSlave       | 驱动器名称 |
| Master | IoDrvEtherCAT  | 主站名称  |

**VAR\_OUTPUT**

| **名称**    | **类型** | 初始化   |
| --------- | ------ | ----- |
| Done      | BOOL   | FALSE |
| Busy      | BOOL   | FALSE |
| Error     | BOOL   | FALSE |
| ErrorId   | UINT   |       |

#### MC\_CoEReset
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6807c6b5.png)

##### **接口**

**VAR\_INPUT**

| 名称     | **类型** | 描述    |
| ------ | ------ | ----- |
| Excute | BOOL   | 上升沿触发 |

**VAR\_OUTPUT**

| **名称**     | **类型**                                                                     | 描述      |
| ---------- | -------------------------------------------------------------------------- | ------- |
| Busy       | ARRAY\[0..(MAX\_NUM\_NODE\_MASTER-1),0..(MAX\_NUM\_NODE\_SLAVE-1)] OF BOOL | 执行中     |
| Done       | ARRAY\[0..(MAX\_NUM\_NODE\_MASTER-1),0..(MAX\_NUM\_NODE\_SLAVE-1)] OF BOOL | 复位完成    |
| Error      | ARRAY\[0..(MAX\_NUM\_NODE\_MASTER-1),0..(MAX\_NUM\_NODE\_SLAVE-1)] OF BOOL |         |
| ErrorId    | ARRAY\[0..(MAX\_NUM\_NODE\_MASTER-1),0..(MAX\_NUM\_NODE\_SLAVE-1)] OF UINT |         |
| NodesValid | BOOL                                                                       | 硬件树信息可用 |

#### MC\_ResetECError
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef68f1e37f.png)


##### **接口**

**VAR\_INPUT**

| 名称     | **类型** | 描述    |
| ------ | ------ | ----- |
| Excute | BOOL   | 上升沿触发 |

**VAR\_OUTPUT**

| **名称**     | **类型**                                        | 描述      |
| ---------- | --------------------------------------------- | ------- |
| Busy       | ARRAY\[0..(MAX\_NUM\_NODE\_MASTER-1)] OF BOOL | 执行中     |
| Done       | ARRAY\[0..(MAX\_NUM\_NODE\_MASTER-1)] OF BOOL | 复位完成    |
| Error      | ARRAY\[0..(MAX\_NUM\_NODE\_MASTER-1)] OF BOOL |         |
| ErrorId    | ARRAY\[0..(MAX\_NUM\_NODE\_MASTER-1)] OF UINT |         |
| NodesValid | BOOL                                          | 硬件树信息可用 |

### **（三）Output to Control Equipment**

#### FB\_DeadBand
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef69963d1f.png)


##### **接口**

**VAR\_INPUT**

| 名称  | **类型** | 描述 |
| --- | ------ | -- |
| fIn | LREAL  |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**             | 描述 |
| -------- | ------------------ | -- |
| stParams | ST\_DeadBandParams |    |

**VAR\_OUTPUT**

| **名称**              | **类型**           | 初始化 |
| ------------------- | ---------------- | --- |
| fOut                | LREAL            |     |
| bInIsUnderThreshold | BOOL             |     |
| eErrorId            | E\_CtrlErrorCode |     |
| bError              | BOOL             |     |

##### 结构体

**ST\_DeadBandParams**

| **名称**         | **类型** | 初始化      | 描述 |
| -------------- | ------ | -------- | -- |
| tCtrlCycleTime | TIME   | TIME#0ms |    |
| tTaskCycleTime | TIME   | TIME#0ms |    |
| fThreshold     | LREAL  |          |    |

#### FB\_Limiter
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6a382578.png)

##### **接口**

**VAR\_INPUT**

| 名称  | **类型** | 描述 |
| --- | ------ | -- |
| fIn | LREAL  |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**            | 描述 |
| -------- | ----------------- | -- |
| stParams | ST\_LimiterParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 初始化 |
| ---------- | ---------------- | --- |
| fOut       | LREAL            |     |
| bMinLimit  | BOOL             |     |
| bMaxLimit  | BOOL             |     |
| eErrorId   | E\_CtrlErrorCode |     |
| bError     | BOOL             |     |

##### 结构体

**ST\_LimiterParams**

| **名称**         | **类型** | 初始化      | 描述 |
| -------------- | ------ | -------- | -- |
| tCtrlCycleTime | TIME   | TIME#0ms |    |
| tTaskCycleTime | TIME   | TIME#0ms |    |
| fMinOutput     | LREAL  |          |    |
| fMaxOutput     | LREAL  |          |    |

#### FB\_PWMOut
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6acb08c9.png)


##### **接口**

**VAR\_INPUT**

| 名称     | **类型**      | 描述 |
| ------ | ----------- | -- |
| fPwmIn | LREAL       |    |
| eMode  | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**           | 描述 |
| -------- | ---------------- | -- |
| stParams | ST\_PWMOutParams |    |

**VAR\_OUTPUT**

| **名称**        | **类型**           | 初始化 |
| ------------- | ---------------- | --- |
| bPwmOutBitPos | BOOL             |     |
| bPwmOutBitNeg | BOOL             |     |
| eState        | E\_CtrlState     |     |
| eErrorId      | E\_CtrlErrorCode |     |
| bError        | BOOL             |     |

##### 结构体

**ST\_PWMOutParams**

| **名称**            | **类型** | 初始化      | 描述 |
| ----------------- | ------ | -------- | -- |
| tTaskCycleTime    | TIME   | TIME#0ms |    |
| tPWMPeriod        | TIME   |          |    |
| bInstantPWMUpdate | BOOL   |          |    |

#### FB\_PWMOutExt
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6b7a0bcc.png)


##### **接口**

**VAR\_INPUT**

| 名称     | **类型**      | 描述 |
| ------ | ----------- | -- |
| fPwmIn | LREAL       |    |
| eMode  | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**              | 描述 |
| -------- | ------------------- | -- |
| stParams | ST\_PWMOutExtParams |    |

**VAR\_OUTPUT**

| **名称**          | **类型**           | 描述 |
| --------------- | ---------------- | -- |
| bPwmOutBitPos   | BOOL             |    |
| bPwmOutBitNeg   | BOOL             |    |
| bWaitTimeActive | BOOL             |    |
| eState          | E\_CtrlState     |    |
| eErrorId        | E\_CtrlErrorCode |    |
| bError          | BOOL             |    |

##### 结构体

**ST\_PWMOutExtParams**

| **名称**                     | **类型** | 初始化      | 描述 |
| -------------------------- | ------ | -------- | -- |
| tTaskCycleTime             | TIME   | TIME#0ms |    |
| tPWMPeriod                 | TIME   |          |    |
| tMinOnTime                 | TIME   |          |    |
| tMinOffTime                | TIME   |          |    |
| tMinWaitTime               | TIME   |          |    |

### **（四）Signal**

#### FB\_NoiseGenerator
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6c1807b0.png)


##### **接口**

**VAR\_INPUT**

| 名称            | **类型**      | 描述 |
| ------------- | ----------- | -- |
| fManSyncValue | LREAL       |    |
| eMode         | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**                   | 描述 |
| -------- | ------------------------ | -- |
| stParams | ST\_NoiseGeneratorParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_NoiseGeneratorParams**

| **名称**                     | **类型** | 初始化      | 描述 |
| -------------------------- | ------ | -------- | -- |
| tCtrlCycleTime             | TIME   | TIME#0ms |    |
| tTaskCycleTime             | TIME   | TIME#0ms |    |
| fAmplitude                 | LREAL  | 0        |    |

#### FB\_Ramp
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6cba65ed.png)


##### **接口**

**VAR\_INPUT**

| 名称      | **类型** | 描述 |
| ------- | ------ | -- |
| bEnable | LREAL  |    |
| fStart  | LREAL  |    |
| fTarget | LREAL  |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**         | 描述 |
| -------- | -------------- | -- |
| stParams | ST\_RampParams |    |

**VAR\_OUTPUT**

| **名称**        | **类型**           | 描述 |
| ------------- | ---------------- | -- |
| fOut          | LREAL            |    |
| fVeloOut      | LREAL            |    |
| bValueReached | BOOL             |    |
| eErrorId      | E\_CtrlErrorCode |    |
| bError        | BOOL             |    |

##### 结构体

**ST\_RampParams**

| **名称**               | **类型** | 初始化      | 描述 |
| -------------------- | ------ | -------- | -- |
| tCtrlCycleTime       | TIME   | TIME#0ms |    |
| tTaskCycleTime       | TIME   | TIME#0ms |    |
| fVeloPos             | LREAL  |          |    |
| fVeloNeg             | LREAL  |          |    |

#### FB\_Random

#### FB\_SetPointGenerator
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6d7dc2ff.png)


##### **接口**

**VAR\_INPUT**

| 名称              | **类型**      | 描述 |
| --------------- | ----------- | -- |
| nStepointIndex  | INT         |    |
| fManValue       | LREAL       |    |
| eMode           | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**                      | 描述 |
| -------- | --------------------------- | -- |
| stParams | ST\_SetPointGeneratorParams |    |

**VAR\_OUTPUT**

| **名称**        | **类型**           | 描述 |
| ------------- | ---------------- | -- |
| fOut          | LREAL            |    |
| bValueReached | BOOL             |    |
| eState        | E\_CtrlState     |    |
| eErrorId      | E\_CtrlErrorCode |    |
| bError        | BOOL             |    |

##### 结构体

**ST\_SetPointGeneratorParams**

| **名称**                   | **类型**           | 初始化      | 描述 |
| ------------------------ | ---------------- | -------- | -- |
| tCtrlCycleTime           | TIME             | TIME#0ms |    |
| tTaskCycleTime           | TIME             | TIME#0ms |    |
| pDataTable\_ADR          | POINTER TO LREAL | 0        |    |
| pDataTable\_SIZEOF       | UINT             | 0        |    |
| pDataTable\_NumberOfRows | UINT             | 0        |    |
| fVeloPos                 | LREAL            |          |    |
| fVeloNeg                 | LREAL            |          |    |
| bDisableRamping          | BOOL             | FALSE    |    |

#### FB\_SignalGenerator
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6e30c3b2.png)


##### **接口**

**VAR\_INPUT**

| 名称         | **类型**      | 描述 |
| ---------- | ----------- | -- |
| fManValue  | LREAL       |    |
| eMode      | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**                    | 描述 |
| -------- | ------------------------- | -- |
| stParams | ST\_SignalGeneratorParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_SignalGeneratorParams**

| **名称**                     | **类型**            | 初始化      | 描述 |
| -------------------------- | ----------------- | -------- | -- |
| tCtrlCycleTime             | TIME              | TIME#0ms |    |
| tTaskCycleTime             | TIME              | TIME#0ms |    |
| eSignalType                | E\_CtrlSignalType |          |    |
| tCycleDuration             | TIME              |          |    |
| fAmplitude                 | LREAL             |          |    |
| fOffset                    | LREAL             | 0.0      |    |
| fStart                     | TIME              | TIME#0ms |    |

### **（五）SignalProcess**

#### FB\_DigitalFilter
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6eead86d.png)


##### **接口**

**VAR\_INPUT**

| 名称         | **类型**      | 描述 |
| ---------- | ----------- | -- |
| fIn        | LREAL       |    |
| fManValue  | LREAL       |    |
| eMode      | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**                  | 描述 |
| -------- | ----------------------- | -- |
| stParams | ST\_DigitalFilterParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_DigitalFilterParams**

| **名称**                        | **类型**                           | 初始化      | 描述 |
| ----------------------------- | -------------------------------- | -------- | -- |
| tCtrlCycleTime                | TIME                             | TIME#0ms |    |
| tTaskCycleTime                | TIME                             | TIME#0ms |    |
| nFilterOrder                  | USINT                            |          |    |
| pCoefficientsArray\_a\_ADR    | POINTER TO LREAL                 |          |    |
| nCoefficientsArray\_a\_SIZEOF | UINT                             |          |    |
| pCoefficientsArray\_b\_ADR    | POINTER TO LREAL                 |          |    |
| nCoefficientsArray\_b\_SIZEOF | UINT                             |          |    |
| pDigitalFilterData\_ADR       | POINTER TO ST\_DigitalFilterData |          |    |
| nDigitalFilterData\_SIZEOF    | UINT                             |          |    |

#### FB\_MovingAverageFilter
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef6f820c49.png)


##### **接口**

**VAR\_INPUT**

| 名称             | **类型**      | 描述 |
| -------------- | ----------- | -- |
| fIn            | LREAL       |    |
| fManSyncValue  | LREAL       |    |
| bSync          | BOOL        |    |
| eMode          | E\_CtrlMode |    |
| bHold          | BOOL        |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**                        | 描述 |
| -------- | ----------------------------- | -- |
| stParams | ST\_MovingAverageFilterParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_MovingAverageFilterParams**

| **名称**                     | **类型**           | 初始化      | 描述      |
| -------------------------- | ---------------- | -------- | ------- |
| tCtrlCycleTime             | TIME             | TIME#0ms | 控制周期时间  |
| tTaskCycleTime             | TIME             | TIME#0ms | 任务周期时间  |
| nSamplesToFilter           | UINT             |          | 采样个数    |
| pWorkArray                 | POINTER TO LREAL | 0        | 缓冲区数组地址 |
| nWorkArraySize             | UINT             | 0        | 缓冲区数组大小 |

#### FB\_NotchFilter
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef704954dc.png)


##### **接口**

**VAR\_INPUT**

| 名称         | **类型**      | 描述 |
| ---------- | ----------- | -- |
| fIn        | LREAL       |    |
| fManValue  | LREAL       |    |
| eMode      | E\_CtrlMode |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**                | 描述 |
| -------- | --------------------- | -- |
| stParams | ST\_NotchFilterParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_NotchFilterParams**

| **名称**                | **类型** | 初始化      | 描述     |
| --------------------- | ------ | -------- | ------ |
| tCtrlCycleTime        | TIME   | TIME#0ms | 控制周期时间 |
| tTaskCycleTime        | TIME   | TIME#0ms | 任务周期时间 |
| fNotchFreq            | LREAL  | 0        | 频率     |
| fBandwidth            | LREAL  | 0        | 带宽     |

#### FB\_PT1
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef710af2c8.png)


##### **接口**

**VAR\_INPUT**

| 名称             | **类型**      | 描述 |
| -------------- | ----------- | -- |
| fIn            | LREAL       |    |
| fManSyncValue  | LREAL       |    |
| bSync          | BOOL        |    |
| eMode          | E\_CtrlMode |    |
| bHold          | BOOL        |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**        | 描述 |
| -------- | ------------- | -- |
| stParams | ST\_PT1Params |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_PT1Params**

| **名称**         | **类型** | 初始化      | 描述     |
| -------------- | ------ | -------- | ------ |
| tCtrlCycleTime | TIME   | TIME#0ms | 控制周期时间 |
| tTaskCycleTime | TIME   | TIME#0ms | 任务周期时间 |
| fKp            | LREAL  | 0        |        |
| tT1            | TIME   | TIME#0ms |        |

#### FB\_PT2
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef719c8586.png)


##### **接口**

**VAR\_INPUT**

| 名称         | **类型**      | 描述 |
| ---------- | ----------- | -- |
| fIn        | LREAL       |    |
| fManValue  | LREAL       |    |
| eMode      | E\_CtrlMode |    |
| bHold      | BOOL        |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**        | 描述 |
| -------- | ------------- | -- |
| stParams | ST\_PT2Params |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_PT2Params**

| **名称**         | **类型** | 初始化      | 描述     |
| -------------- | ------ | -------- | ------ |
| tCtrlCycleTime | TIME   | TIME#0ms | 控制周期时间 |
| tTaskCycleTime | TIME   | TIME#0ms | 任务周期时间 |
| fKp            | LREAL  | 0        |        |
| tT1            | TIME   | TIME#0ms |        |
| tT2            | TIME   | TIME#0ms |        |

#### FB\_PTn
![](https://resource.helplook.net/docker_production/3648ne/article/dynYmHkh/680ef723c1fcd.png)


##### **接口**

**VAR\_INPUT**

| 名称         | **类型**      | 描述 |
| ---------- | ----------- | -- |
| fIn        | LREAL       |    |
| fManValue  | LREAL       |    |
| eMode      | E\_CtrlMode |    |
| bHold      | BOOL        |    |

**VAR\_IN\_OUT**

| **名称**   | **类型**        | 描述 |
| -------- | ------------- | -- |
| stParams | ST\_PTnParams |    |

**VAR\_OUTPUT**

| **名称**     | **类型**           | 描述 |
| ---------- | ---------------- | -- |
| fOut       | LREAL            |    |
| eState     | E\_CtrlState     |    |
| eErrorId   | E\_CtrlErrorCode |    |
| bError     | BOOL             |    |

##### 结构体

**ST\_PTnParams**

| **名称**                     | **类型** | 初始化      | 描述     |
| -------------------------- | ------ | -------- | ------ |
| tCtrlCycleTime             | TIME   | TIME#0ms | 控制周期时间 |
| tTaskCycleTime             | TIME   | TIME#0ms | 任务周期时间 |
| nOrder                     | UINT   |          |        |
| fKp                        | LREAL  | 0        |        |
| tT1                        | TIME   | TIME#0ms |        |

## 三、全局常量



## 四、数据结构

#### 结构体和枚举定义

##### FLOAT:

该库的功能块只与FLOAT数据类型一起工作。该数据类型在附加库中定义为 LREAL 或 REAL 。

##### E\_CtrlMode

##### E\_CtrlState

##### E\_CtrlErrorCode

##### E\_CtrlSignalType